(************************************************************************
 *                                                                      *
 *   Ant Movie Catalog 4.x                                              *
 *   (C) 2000-2006 Antoine Potten                                       *
 *   http://www.antp.be/software                                        *
 *                                                                      *
 ************************************************************************
 *                                                                      *
 *   This program is free software; you can redistribute it and/or      *
 *   modify it under the terms of the GNU General Public License        *
 *   as published by the Free Software Foundation; either version 2     *
 *   of the License, or (at your option) any later version.             *
 *                                                                      *
 *   This program is distributed in the hope that it will be useful,    *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of     *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the      *
 *   GNU General Public License for more details.                       *
 *                                                                      *
 ************************************************************************)

unit getfile;

interface

uses
  SysUtils, StrUtils, Math, Forms, Controls,

  framemovie;

function GetInfoFromMediaFile(const FileName: TFileName; FrmMovie: TMovieFrame): Boolean;

{-------------------------------------------------------------------------------
-------------------------------------------------------------------------------}

implementation

uses
  IniFiles,

  ConstValues, Global, functions_files, functions_str, functions_video, MediaInfo,
  ProgramSettings, AntJvSpin, functions_gui;

{-------------------------------------------------------------------------------
-------------------------------------------------------------------------------}

function GetInfoFromMediaFile(const FileName: TFileName; FrmMovie: TMovieFrame): Boolean;
var
  ext: string;
  AVIResX, AVIResY, AVILength, VideoBitrate, AudioBitrate: Integer;
  AVIRate: Single;
  VideoCodec, AudioCodec: string;
  StreamCount: Integer;
  i, c, n: Integer;
  s: string;
begin
  Result := True;
  ext := LowerCase(ExtractFileExt(FileName));
  with Settings.rOptions.rMovieInformation do
  begin
    if ImportSize then
      with FrmMovie do
      begin
        s := ESize.Text;
        c := IfThen(EDisks.Text <> '', EDisks.AsInteger, 0);
        ExtractFileSize(FileName, ImportSizeString, s, c, ImportSizeUnit);
        ESize.Text := s;
        EDisks.Value := c;
      end;
    if ImportMediaLabel and (UpCase(FileName[1]) in ['A'..'Z']) then
        FrmMovie.EMedia.Text := GetVolumeLabel(FileName[1]);
    if ImportFileName then
      FrmMovie.EOriginalTitle.Text := ChangeFileExt(ExtractFileName(FileName), '');
    if ImportFileNameURL then
      FrmMovie.EURL.Text := FileName;
    if ImportInternalAVI and (ext = extVideo[extAVI]) then
    begin
      if ExtractAVIInfos(FileName, AVIResX, AVIResY, AVILength, AVIRate, VideoCodec, AudioCodec, VideoBitrate, AudioBitrate) then
      begin
        if ImportResolution then
          FrmMovie.EResolution.Text := Format('%dx%d', [AVIResX, AVIResY]);
        if ImportLength then
        begin
          if FrmMovie.ELength.Text = '' then
            FrmMovie.ELength.Value := AVILength
          else
            FrmMovie.ELength.Value := AVILength + FrmMovie.ELength.Value;
        end;
        if ImportFramerate then
        begin
          FrmMovie.EFramerate.Text := FloatToStr(trunc(AVIRate*1000)/1000);
        end;
        if ImportVideoCodec or ImportAudioCodec then
        begin
          with TMemIniFile.Create(strDirApp + strFileCodecs) do
            try
              if (ImportVideoCodec) and (VideoCodec <> '') then
                FrmMovie.EVideoFormat.Text := ReadString('Video', VideoCodec, '?');
              if (ImportAudioCodec) and (AudioCodec <> '') then
                with FrmMovie.EAudioFormat do
                  begin
                    Text := '';
                    for i := 0 to (Length(AudioCodec) div 4) - 1 do
                    begin
                      if Text <> '' then
                        Text := Text + '/';
                      Text := Text + ReadString('Audio', Copy(AudioCodec, (i * 4) + 1, 4), '?');
                    end;
                  end;
            finally
              Free;
            end; // with TMemIniFile
        end;
        if ImportVideoBitrate and (VideoBitrate > 0) then
        begin
          if FrmMovie.EVideoBitrate.Value > 0 then
            FrmMovie.EVideoBitrate.Value := (FrmMovie.EVideoBitrate.AsInteger + VideoBitrate) div 2
          else
            FrmMovie.EVideoBitrate.Value := VideoBitrate;
        end;
        if ImportAudioBitrate and (AudioBitrate > 0) then
        begin
          if FrmMovie.EAudioBitrate.Value > 0 then
            FrmMovie.EAudioBitrate.Value := (FrmMovie.EAudioBitrate.AsInteger + AudioBitrate) div 2
          else
            FrmMovie.EAudioBitrate.Value := AudioBitrate;
        end;
      end // if ExtractAVIInfos
    end // if extAVI
    else
    begin
      SetWaitCursor;
      try
        with TMediaInfo.Create(strDirApp + strFileMediaInfoDLL, True) do
          try
            if Open(FileName) <> 0 then
            begin
              if ImportLength then
                try
                  AVILength := StrToIntDef(Get(misStreamGeneral, 0, 'PlayTime'), 0) div 1000 div 60;
                  if FrmMovie.ELength.Text = '' then
                    FrmMovie.ELength.Value := AVILength
                  else
                    FrmMovie.ELength.Value := AVILength + FrmMovie.ELength.Value;
                except
                end;
              StreamCount := StrToIntDef(Get(misStreamGeneral, 0, 'VideoCount'), 0);
              if StreamCount > 0 then
              begin
                if ImportVideoCodec then
                  with FrmMovie.EVideoFormat do
                  begin
                    Text := '';
                    for i := 0 to StreamCount-1 do
                    begin
                      s := Get(misStreamVideo, i, 'Codec/String');
                      if s <> '' then
                      begin
                        if Text <> '' then
                          Text := Text + ', ';
                        Text := Text + s;
                      end;
                    end;
                  end;
                if ImportVideoBitrate then
                  with FrmMovie.EVideoBitrate do
                  begin
                    c := 0;
                    VideoBitrate := 0;
                    for i := 0 to StreamCount-1 do
                    begin
                      n := StrToIntTrunc(Get(misStreamVideo, i, 'BitRate')) div 1000;
                      if n > 0 then
                      begin
                        Inc(VideoBitrate, n);
                        Inc(c);
                      end;
                    end;
                    if c > 0 then
                      VideoBitrate := VideoBitrate div c;
                    if VideoBitrate > 0 then
                      if AsInteger > 0 then
                        AsInteger := (AsInteger +  VideoBitrate) div 2
                      else
                        AsInteger := VideoBitrate;
                  end;
                if ImportResolution then
                  FrmMovie.EResolution.Text := Format('%sx%s', [Get(misStreamVideo, 0, 'Width'), Get(misStreamVideo, 0, 'Height')]);
                if ImportFramerate then
                  FrmMovie.EFramerate.Text := Get(misStreamVideo, 0, 'FrameRate');
              end; // video streams > 0
              StreamCount := StrToIntDef(Get(misStreamGeneral, 0, 'AudioCount'), 0);
              if StreamCount > 0 then
              begin
                if ImportAudioCodec then
                  with FrmMovie.EAudioFormat do
                  begin
                    Text := '';
                    for i := 0 to StreamCount-1 do
                    begin
                      s := Get(misStreamAudio, i, 'Codec/String');
                      if s <> '' then
                      begin
                        if Text <> '' then
                          Text := Text + ', ';
                        Text := Text + s;
                      end;
                    end;
//                    if (Text = '') and (ext = extVideo[extTS]) then
//                      Text := 'Dolby Digital 5.1';
                  end;
                if ImportAudioBitrate then
                  with FrmMovie.EAudioBitrate do
                  begin
                    c := 0;
                    AudioBitrate := 0;
                    for i := 0 to StreamCount-1 do
                    begin
                      n := StrToIntTrunc(Get(misStreamAudio, i, 'BitRate')) div 1000;
                      if n > 0 then
                      begin
                        Inc(AudioBitrate, n);
                        Inc(c);
                      end;
                    end;
                    if c > 0 then
                      AudioBitrate := AudioBitrate div c;
                    if AudioBitrate > 0 then
                      if AsInteger > 0 then
                        AsInteger := (AsInteger +  AudioBitrate) div 2
                      else
                        AsInteger := AudioBitrate;
                  end;
                if ImportLanguages then
                  with FrmMovie.ELanguages do
                  begin
                    Text := '';
                    for i := 0 to StreamCount-1 do
                    begin
                      s := Get(misStreamAudio, i, 'Language/String');
                      if s <> '' then
                      begin
                        if Text <> '' then
                          Text := Text + ', ';
                        Text := Text + s;
                      end;
                    end;
                  end;
              end; // audio streams > 0
              StreamCount := StrToIntDef(Get(misStreamGeneral, 0, 'TextCount'), 0);
              if StreamCount > 0 then
              begin
                if ImportSubtitles then
                  with FrmMovie.ESubtitles do
                  begin
                    Text := '';
                    for i := 0 to StreamCount-1 do
                    begin
                      s := Get(misStreamText, i, 'Language/String');
                      if s <> '' then
                      begin
                        if Text <> '' then
                          Text := Text + ', ';
                        Text := Text + s;
                      end;
                    end;
                  end;
              end; // text streams > 0
            end; // if open
          finally
            Free;
          end;
      finally
        RestoreCursor;
      end;
    end;
  end;
end;

{-------------------------------------------------------------------------------
-------------------------------------------------------------------------------}

end.
